﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Gemini.Core.JSON.LitJson;

namespace PI.ZB.N1200.ELearning.BL.APIMobile.Model
{
    /// <summary>
    /// Klasa zarzadzajaca odpowiedzia porpzez API
    /// </summary>
    public class GResponse
    {
        /// <summary>
        /// Serializowanie obiektu ResponseData do postaci JSON
        /// </summary>
        /// <param name="ResponseData"></param>
        /// <returns></returns>
        public static string ToJson(GResponseData ResponseData)
        {

            if (ResponseData is GResponseData_InnerData)
            {
                return UnicodeToUTF8(JsonMapper.ToJson(((GResponseData_InnerData)ResponseData).InnerData, false));
            }
            return JsonMapper.ToJson(ResponseData, false);
        }

        private static string UnicodeToUTF8(string UnicodeValue)
        {
            Encoding unicode = Encoding.Unicode;
            Encoding utf8 = Encoding.UTF8;

            byte[] unicodeBytes = unicode.GetBytes(UnicodeValue);
            byte[] utf8Bytes = Encoding.Convert(unicode, utf8, unicodeBytes);

            return utf8.GetString(utf8Bytes);
        }
    }
}